<?PHP
	$this->load->helper("url");
	
	if(!isset($inline)) {
		$msg = $this->peeker->get_message($id);
		$parts = $msg->get_parts_array();
		foreach($parts as $part) {
			if($part->filename == html_entity_decode(rawurldecode($filename))) {
				if(strtolower($part->subtype) == "jpg" || strtolower($part->subtype) == "jpeg" || strtolower($part->subtype) == "gif" || strtolower($part->subtype) == "png" || strtolower($part->subtype) == "tiff") {
					$ContentType = "image/" . $part->subtype;
					header ("Content-Type: $ContentType"); //set content type in headers
					header('Content-Disposition: attachment; filename="' . $part->filename . '"');
					echo $part->string;
				}
				else {
					header("Content-Type: application/force-download");
					header("Content-Disposition: attachment; filename=\"" . $part->filename . "\"");
					header("Content-Transfer-Encoding: binary");
					echo $part->string;
				}
			}
		}
	}
	//this could should only be called when there is a single inline image taking up the entire body of the message
	//and there is no parts array, a condition that only seems to happen when an image is sent in apple mail
	//inline with no text also included
	else {
		$msg = $this->peeker->get_message($id);
		$filename = strtolower(rawurldecode($filename));
		if(strtolower($inline) == "jpg" || strtolower($inline) == "jpeg" || strtolower($inline) == "gif" || strtolower($inline) == "png" || strtolower($inline) == "tiff") {
			$ContentType = "image/" . $inline;
			header ("Content-Type: $ContentType"); //set content type in headers
			header('Content-Disposition: attachment; filename="' . $filename . '"');
			echo base64_decode($msg->body_string);
		}
	}
?>
